"""
cPanel-compatible runner for the social media bot
This file is designed to work with cPanel's Python App setup
"""
import sys
import os

# Add current directory to path
sys.path.insert(0, os.path.dirname(__file__))

from scheduler import *

# WSGI application entry point (required by some cPanel setups)
def application(environ, start_response):
    status = '200 OK'
    output = b'Social Media Bot is running via scheduler.py'
    
    response_headers = [('Content-type', 'text/plain'),
                        ('Content-Length', str(len(output)))]
    start_response(status, response_headers)
    
    return [output]

if __name__ == '__main__':
    # Run scheduler directly when executed
    print("Starting Social Media Bot Scheduler...")
    # The scheduler loop is already in scheduler.py
