#!/bin/bash
# Check if bot is running on cPanel

echo "Checking bot status..."
echo ""

if pgrep -f scheduler.py > /dev/null; then
    echo "✓ Bot is RUNNING"
    echo ""
    echo "Process details:"
    ps aux | grep scheduler.py | grep -v grep
    echo ""
    echo "Recent logs:"
    tail -n 20 ~/bot_poster/bot.log
else
    echo "✗ Bot is NOT running"
    echo ""
    echo "Last 10 log entries:"
    tail -n 10 ~/bot_poster/bot.log
fi
